<?php
/**
 * Module Name: Youzer for WordPress Integration
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

if ( class_exists('Youzer') ) :

class WPAchievements_Module_YZ {

  /**
   * Init required hooks
   *
   * @static
   * @access  public
   * @return  void
   */
  public static function init() {

    //add_action( 'bp_setup_nav', array( __CLASS__, 'extend_bp_navigation' ) );

    // Register settings hooks
    add_filter( 'wpachievements_get_sections_module', array( __CLASS__, 'register_section' ) );
    add_filter( 'wpachievements_achievements_modules_admin_settings', array( __CLASS__, 'admin_settings'), 10, 3 );

    // Additional Functions
    add_action( 'bp_directory_members_item_meta', array( __CLASS__, 'yz_members_grid' ) );

    // Extend default options of youzer to show correct icon
    add_filter( 'yz_default_options', array( __CLASS__, 'yz_extend_default_options'), 10, 1 );
  }

  /**
    * Extend youzer css options
    *
    * @static
    * @param  array $options options array of youzer
    * @access  public
    * @return array $options extended options array of youzer
    */
  public static function yz_extend_default_options( $options ) {

    // Options.
    $yzsq_options = array(
      'yz_wpa-badges_tab_icon' => 'trophy',
    );

    $options = array_merge( $options, $yzsq_options );

    return $options;
  }

  /**
  * Show rank status in profile member grid
  *
  * @static
  * @access  public
  * @return
  */
  public static function yz_members_grid() {

    if ( ! function_exists( 'bp_get_member_user_id' ) ) {
      return;
    }

    $user_id = bp_get_member_user_id();

    if ( 'Disable' != wpachievements_get_site_option('wpachievements_rank_status') ) {
      echo '<span class="yz-name yzm-user-statistics"><strong>'.__('Rank', 'wpachievements').':</strong> '.wpachievements_getRank( $user_id ).'</span>';
    }

    // Get badges visibility
    if ( 'Disable' == wpachievements_get_site_option('wpachievements_yz_show_achquests_user_card') ) {
      return;
    }

    // Get Bages max number.
    $max_badges = intval( wpachievements_get_site_option( 'wpachievements_yz_max_card_user_badges' ) );

    // Get Ballance
    $userachievements = get_user_meta( $user_id, 'achievements_gained', true );
    $userquests = get_user_meta( $user_id, 'quests_gained', true );

    if ($max_badges > 0) {
      if ( is_array( $userachievements ) ) {
        $userachievements = array_slice( $userachievements, 0 , $max_badges );
      }
      if ( is_array( $userquests ) ) {
        $userquests = array_slice( $userquests, 0 , $max_badges );
      }
    }

    ?>
    <div class="yz-md-user-badges yzm-user-statistics">
      <?php
      if ( ! empty( $userachievements ) ) {
        foreach ( $userachievements as $list_id => $achievement_id ) {
          $achievement_img_url = get_post_meta( $achievement_id, '_achievement_image', true );
          echo '<div class="yz-badge-item" data-yztooltip="' . get_the_title( $achievement_id ) . '">';
          echo '<img src="'. $achievement_img_url .'" class="mycred-badge-image" title="'. get_the_title( $achievement_id ) .'" alt="'. get_the_title( $achievement_id ) .'" width="35" height="35">';
          echo '</div>';
        }
      }
      if ( ! empty( $userquests ) ) {
        foreach ( $userquests as $list_id => $quest_id ) {
          $quest_img_url = get_post_meta( $quest_id, '_quest_image', true );
          echo '<div class="yz-badge-item" data-yztooltip="' . get_the_title( $quest_id ) . '">';
          echo '<img src="'. $quest_img_url .'" class="mycred-badge-image" title="'. get_the_title( $quest_id ) .'" alt="'. get_the_title( $quest_id ) .'" width="35" height="35">';
          echo '</div>';
        }
      }
      ?>
    </div>
    <?php
  }

  /**
   * Register admin section
   *
   * @static
   * @access  public
   * @param   array $sections Array of registered sections for admin settings
   * @return  array           Sections
   */
  public static function register_section( $sections ) {
    $sections['yz'] = __("Youzer", 'wpachievements' );

    return $sections;
  }

  /**
   * Admin settings
   *
   * @static
   * @access  public
   * @param   array $default_settings
   * @param   string $short_name
   * @param   string $section
   * @return  array
   */
  public static function admin_settings( $default_settings, $short_name, $section ) {

    if ( $section !== 'yz' ) {
      return $default_settings;
    }

    $settings = array();

    $settings[] = array( 'title' => __( 'Youzer', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'YZ_options' );

    $settings[] = array(
      'title'   => __( 'User/Member Card Grid', 'wpachievements' ),
      'desc'    => __( 'Select to show Achievments/Quests in the user grid card.', 'wpachievements' ),
      'id'      => 'wpachievements_yz_show_achquests_user_card',
      'type'    => 'select',
      'default' => 'Enable',
      'css'     => 'min-width:300px;',
      'options' => array(
        'Enable'  => __('Enable','wpachievements' ),
        'Disable'  => __('Disable', 'wpachievements' ),
      ),
    );

    $settings[] = array(
      'title'   => __( 'Max. User/Member Card Items', 'wpachievements' ),
      'desc'    => __( 'Enter the number of max items to show.<br/>(Enter 0 to show all)', 'wpachievements' ),
      'id'      => 'wpachievements_yz_max_card_user_badges',
      'type'    => 'text',
      'default' => '0',
    );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'YZ_options');

    return $settings;
  }
}

WPAchievements_Module_YZ::init();

endif;
